<?php
require_once '../config/database.php';
header('Content-Type: application/json');

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    
    // Get campaign
    $campaign = $conn->query("
        SELECT c.*, t.name as template_name,
               (SELECT COUNT(*) FROM email_logs WHERE campaign_id = c.id AND status='sent') as sent_count,
               (SELECT COUNT(*) FROM email_logs WHERE campaign_id = c.id AND status='failed') as failed_count
        FROM email_campaigns c
        LEFT JOIN email_templates t ON c.template_id = t.id
        WHERE c.id = $id
    ")->fetch_assoc();
    
    // Get logs
    $logs = [];
    $logsResult = $conn->query("
        SELECT * FROM email_logs 
        WHERE campaign_id = $id 
        ORDER BY sent_at DESC 
        LIMIT 20
    ");
    
    while($log = $logsResult->fetch_assoc()) {
        $logs[] = $log;
    }
    
    echo json_encode([
        'success' => true,
        'campaign' => $campaign,
        'logs' => $logs
    ]);
}
?>