<?php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

// Clear any previous output
ob_clean();

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    
    // Clear any pending results
    while ($conn->more_results()) {
        $conn->next_result();
        if ($result = $conn->store_result()) {
            $result->free();
        }
    }
    
    $result = $conn->query("SELECT * FROM email_templates WHERE id = $id");
    
    if ($result && $result->num_rows > 0) {
        $template = $result->fetch_assoc();
        
        // Clean the HTML content for JSON
        $html_content = $template['html_content'];
        $html_content = str_replace(["\r", "\n"], '', $html_content);
        $html_content = addslashes($html_content);
        
        echo json_encode([
            'success' => true,
            'name' => $template['name'],
            'html_content' => $template['html_content']
        ], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => 'Template not found'
        ]);
    }
    
    // Free result
    if ($result) {
        $result->free();
    }
} else {
    echo json_encode([
        'success' => false, 
        'message' => 'No template ID provided'
    ]);
}

// Close connection
$conn->close();
exit();
?>