<?php
session_start();

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'mail_system');

// Create connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set charset to UTF-8
$conn->set_charset("utf8mb4");

// Create tables if they don't exist - ONE BY ONE
$tables_sql = [
    // Users table
    "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        email VARCHAR(100) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    // Email templates table
    "CREATE TABLE IF NOT EXISTS email_templates (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL,
        html_content TEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    // Email receivers table
    "CREATE TABLE IF NOT EXISTS email_receivers (
        id INT AUTO_INCREMENT PRIMARY KEY,
        email VARCHAR(255) NOT NULL UNIQUE,
        name VARCHAR(100),
        status ENUM('active', 'inactive') DEFAULT 'active',
        added_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    // SMTP settings table
    "CREATE TABLE IF NOT EXISTS smtp_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        host VARCHAR(255) NOT NULL,
        port INT NOT NULL,
        username VARCHAR(255) NOT NULL,
        password VARCHAR(255) NOT NULL,
        encryption VARCHAR(10) DEFAULT 'tls',
        from_email VARCHAR(255) NOT NULL,
        from_name VARCHAR(255) NOT NULL,
        is_active BOOLEAN DEFAULT TRUE,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    // Email campaigns table
    "CREATE TABLE IF NOT EXISTS email_campaigns (
        id INT AUTO_INCREMENT PRIMARY KEY,
        template_id INT,
        subject VARCHAR(255) NOT NULL,
        receivers_count INT DEFAULT 0,
        sent_count INT DEFAULT 0,
        failed_count INT DEFAULT 0,
        status ENUM('pending', 'sending', 'completed', 'failed') DEFAULT 'pending',
        sent_at TIMESTAMP NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (template_id) REFERENCES email_templates(id) ON DELETE SET NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    // Campaign receivers table
    "CREATE TABLE IF NOT EXISTS campaign_receivers (
        id INT AUTO_INCREMENT PRIMARY KEY,
        campaign_id INT,
        receiver_id INT,
        FOREIGN KEY (campaign_id) REFERENCES email_campaigns(id) ON DELETE CASCADE,
        FOREIGN KEY (receiver_id) REFERENCES email_receivers(id) ON DELETE CASCADE,
        UNIQUE KEY unique_campaign_receiver (campaign_id, receiver_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    // Email logs table
    "CREATE TABLE IF NOT EXISTS email_logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        campaign_id INT,
        receiver_email VARCHAR(255) NOT NULL,
        subject VARCHAR(255) NOT NULL,
        status ENUM('sent', 'failed') NOT NULL,
        error_message TEXT,
        sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (campaign_id) REFERENCES email_campaigns(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"
];

// Execute each table creation query separately
foreach ($tables_sql as $sql) {
    if (!$conn->query($sql)) {
        // Silent fail - table might already exist
        // You can uncomment below for debugging
        // error_log("Table creation error: " . $conn->error);
    }
}

// Check if admin user exists
$result = $conn->query("SELECT id FROM users WHERE username='admin'");
if (!$result) {
    // If query fails, create users table first
    $conn->query("CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        email VARCHAR(100) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    
    // Retry the query
    $result = $conn->query("SELECT id FROM users WHERE username='admin'");
}

// Add default admin user if not exists
if ($result && $result->num_rows == 0) {
    $password = password_hash('admin123', PASSWORD_DEFAULT);
    $conn->query("INSERT INTO users (username, password, email) VALUES ('admin', '$password', 'admin@example.com')");
}

// Check if SMTP settings exist
$smtp_result = $conn->query("SELECT id FROM smtp_settings LIMIT 1");
if (!$smtp_result) {
    // Create SMTP settings table if it doesn't exist
    $conn->query("CREATE TABLE IF NOT EXISTS smtp_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        host VARCHAR(255) NOT NULL,
        port INT NOT NULL,
        username VARCHAR(255) NOT NULL,
        password VARCHAR(255) NOT NULL,
        encryption VARCHAR(10) DEFAULT 'tls',
        from_email VARCHAR(255) NOT NULL,
        from_name VARCHAR(255) NOT NULL,
        is_active BOOLEAN DEFAULT TRUE,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    
    // Retry the query
    $smtp_result = $conn->query("SELECT id FROM smtp_settings LIMIT 1");
}

// Insert default SMTP settings if not exists
if ($smtp_result && $smtp_result->num_rows == 0) {
    $conn->query("INSERT INTO smtp_settings (host, port, username, password, encryption, from_email, from_name) 
                 VALUES ('smtp.gmail.com', 587, 'your-email@gmail.com', 'your-app-password', 'tls', 'your-email@gmail.com', 'Mail System')");
}

// Function to safely execute queries
function safe_query($sql) {
    global $conn;
    $result = $conn->query($sql);
    if (!$result) {
        error_log("Query error: " . $conn->error);
        return false;
    }
    return $result;
}

// Free any pending results to prevent "commands out of sync" error
while ($conn->more_results()) {
    $conn->next_result();
    if ($result = $conn->store_result()) {
        $result->free();
    }
}

// Clear any pending results
$conn->store_result();
?>