<?php
require_once 'config/database.php';
$page_title = "Dashboard";
require_once 'includes/header.php';

// Get statistics
$totalReceivers = $conn->query("SELECT COUNT(*) as total FROM email_receivers")->fetch_assoc()['total'];
$totalTemplates = $conn->query("SELECT COUNT(*) as total FROM email_templates")->fetch_assoc()['total'];
$totalCampaigns = $conn->query("SELECT COUNT(*) as total FROM email_campaigns")->fetch_assoc()['total'];
$sentEmails = $conn->query("SELECT COUNT(*) as total FROM email_logs WHERE status='sent'")->fetch_assoc()['total'];
?>

<div class="container-fluid">
    <h1 class="mb-4">Dashboard</h1>
    
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card text-center" style="border-top: 5px solid #667eea;">
                <i class="fas fa-users text-primary"></i>
                <h3><?php echo number_format($totalReceivers); ?></h3>
                <p class="text-muted">Total Receivers</p>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card text-center" style="border-top: 5px solid #764ba2;">
                <i class="fas fa-file-code text-purple"></i>
                <h3><?php echo number_format($totalTemplates); ?></h3>
                <p class="text-muted">Email Templates</p>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card text-center" style="border-top: 5px solid #10b981;">
                <i class="fas fa-chart-line text-success"></i>
                <h3><?php echo number_format($totalCampaigns); ?></h3>
                <p class="text-muted">Campaigns</p>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card text-center" style="border-top: 5px solid #f59e0b;">
                <i class="fas fa-paper-plane text-warning"></i>
                <h3><?php echo number_format($sentEmails); ?></h3>
                <p class="text-muted">Emails Sent</p>
            </div>
        </div>
    </div>

    <!-- Recent Campaigns -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-history me-2"></i>Recent Campaigns</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Subject</th>
                                    <th>Sent</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $campaigns = $conn->query("
                                    SELECT c.*, t.name as template_name 
                                    FROM email_campaigns c 
                                    LEFT JOIN email_templates t ON c.template_id = t.id 
                                    ORDER BY c.created_at DESC LIMIT 10
                                ");
                                while($row = $campaigns->fetch_assoc()):
                                ?>
                                <tr>
                                    <td>#<?php echo $row['id']; ?></td>
                                    <td><?php echo htmlspecialchars($row['subject']); ?></td>
                                    <td><?php echo $row['sent_count']; ?>/<?php echo $row['receivers_count']; ?></td>
                                    <td>
                                        <span class="badge bg-<?php 
                                            echo $row['status'] == 'completed' ? 'success' : 
                                                   ($row['status'] == 'sending' ? 'warning' : 
                                                   ($row['status'] == 'failed' ? 'danger' : 'secondary'));
                                        ?>">
                                            <?php echo ucfirst($row['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('Y-m-d H:i', strtotime($row['created_at'])); ?></td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="col-lg-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-bolt me-2"></i>Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="send-mail.php" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane me-2"></i> Send New Email
                        </a>
                        <a href="templates.php" class="btn btn-outline-primary btn-lg">
                            <i class="fas fa-plus-circle me-2"></i> Create Template
                        </a>
                        <a href="receivers.php" class="btn btn-outline-success btn-lg">
                            <i class="fas fa-user-plus me-2"></i> Add Receivers
                        </a>
                        <a href="reports.php" class="btn btn-outline-info btn-lg">
                            <i class="fas fa-chart-bar me-2"></i> View Reports
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>