<?php
// Simple PHPMailer loader without composer
if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
    // Define PHPMailer directory
    $phpmailer_dir = dirname(__DIR__) . '/vendor/phpmailer/phpmailer/';
    
    // If PHPMailer not installed, download it automatically
    if (!file_exists($phpmailer_dir . 'src/PHPMailer.php')) {
        downloadPHPMailer();
    }
    
    // Include PHPMailer files
    require_once $phpmailer_dir . 'src/PHPMailer.php';
    require_once $phpmailer_dir . 'src/SMTP.php';
    require_once $phpmailer_dir . 'src/Exception.php';
    
    // Create alias for easier use
    class_alias('PHPMailer\PHPMailer\PHPMailer', 'PHPMailer');
    class_alias('PHPMailer\PHPMailer\SMTP', 'SMTP');
    class_alias('PHPMailer\PHPMailer\Exception', 'PHPMailerException');
}

function downloadPHPMailer() {
    $phpmailer_url = 'https://github.com/PHPMailer/PHPMailer/archive/refs/tags/v6.6.5.zip';
    $zip_file = dirname(__DIR__) . '/phpmailer.zip';
    $extract_dir = dirname(__DIR__) . '/vendor/';
    
    // Create vendor directory
    if (!file_exists($extract_dir)) {
        mkdir($extract_dir, 0777, true);
    }
    
    // Download PHPMailer
    $zip_content = file_get_contents($phpmailer_url);
    if ($zip_content !== false) {
        file_put_contents($zip_file, $zip_content);
        
        // Extract ZIP file
        $zip = new ZipArchive;
        if ($zip->open($zip_file) === TRUE) {
            $zip->extractTo($extract_dir);
            $zip->close();
            
            // Rename directory
            rename($extract_dir . 'PHPMailer-6.6.5', $extract_dir . 'phpmailer');
            
            // Remove zip file
            unlink($zip_file);
        }
    }
}
?>