<?php
require_once 'config/database.php';
require_once 'vendor/phpmailer/phpmailer/PHPMailerAutoload.php';

if (!isset($_SESSION['campaign_id'])) {
    header('Location: send-mail.php');
    exit();
}

$campaign_id = $_SESSION['campaign_id'];
unset($_SESSION['campaign_id']);

// Get campaign details
$campaign = $conn->query("
    SELECT c.*, t.html_content as template 
    FROM email_campaigns c 
    LEFT JOIN email_templates t ON c.template_id = t.id 
    WHERE c.id = $campaign_id
")->fetch_assoc();

// Get SMTP settings
$smtp = $conn->query("SELECT * FROM smtp_settings LIMIT 1")->fetch_assoc();

// Get receivers for this campaign
$receivers = $conn->query("
    SELECT r.* FROM email_receivers r
    INNER JOIN campaign_receivers cr ON r.id = cr.receiver_id
    WHERE cr.campaign_id = $campaign_id AND r.status = 'active'
");

// Update campaign status to sending
$conn->query("UPDATE email_campaigns SET status = 'sending', sent_at = NOW() WHERE id = $campaign_id");

$sent_count = 0;
$failed_count = 0;

// Send emails
while($receiver = $receivers->fetch_assoc()) {
    try {
        $mail = new PHPMailer(true);
        
        // SMTP configuration
        $mail->isSMTP();
        $mail->Host = $smtp['host'];
        $mail->Port = $smtp['port'];
        $mail->SMTPAuth = true;
        $mail->Username = $smtp['username'];
        $mail->Password = $smtp['password'];
        $mail->SMTPSecure = $smtp['encryption'];
        
        // Recipients
        $mail->setFrom($smtp['from_email'], $smtp['from_name']);
        $mail->addAddress($receiver['email'], $receiver['name'] ?? '');
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = $campaign['subject'];
        
        // Personalize email
        $content = $campaign['template'];
        $content = str_replace('[Client Name]', $receiver['name'] ?? 'Valued Client', $content);
        $content = str_replace('[Email Address]', $receiver['email'], $content);
        
        $mail->Body = $content;
        $mail->AltBody = strip_tags($content);
        
        $mail->send();
        
        // Log success
        $conn->query("
            INSERT INTO email_logs (campaign_id, receiver_email, subject, status, sent_at) 
            VALUES ($campaign_id, '{$receiver['email']}', '{$campaign['subject']}', 'sent', NOW())
        ");
        $sent_count++;
        
    } catch (Exception $e) {
        // Log failure
        $conn->query("
            INSERT INTO email_logs (campaign_id, receiver_email, subject, status, error_message, sent_at) 
            VALUES ($campaign_id, '{$receiver['email']}', '{$campaign['subject']}', 'failed', '{$conn->real_escape_string($mail->ErrorInfo)}', NOW())
        ");
        $failed_count++;
    }
    
    // Add small delay to avoid overwhelming SMTP server
    usleep(100000); // 0.1 second
}

// Update campaign with final stats
$status = $failed_count == 0 ? 'completed' : ($sent_count > 0 ? 'completed' : 'failed');
$conn->query("
    UPDATE email_campaigns 
    SET status = '$status', 
        sent_count = $sent_count, 
        failed_count = $failed_count 
    WHERE id = $campaign_id
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Sent Successfully</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .success-card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 500px;
            width: 100%;
        }
        .success-icon {
            font-size: 80px;
            color: #10b981;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="success-card">
        <div class="success-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        <h2>Campaign Sent Successfully!</h2>
        <p class="lead">Your email campaign has been processed.</p>
        
        <div class="alert alert-success mt-4">
            <h5><i class="fas fa-chart-bar me-2"></i>Campaign Statistics</h5>
            <div class="row mt-3">
                <div class="col-6">
                    <h3 class="text-success"><?php echo $sent_count; ?></h3>
                    <p class="text-muted">Sent</p>
                </div>
                <div class="col-6">
                    <h3 class="text-danger"><?php echo $failed_count; ?></h3>
                    <p class="text-muted">Failed</p>
                </div>
            </div>
        </div>
        
        <div class="mt-4">
            <a href="reports.php" class="btn btn-primary me-2">
                <i class="fas fa-chart-bar me-2"></i> View Reports
            </a>
            <a href="send-mail.php" class="btn btn-outline-primary">
                <i class="fas fa-paper-plane me-2"></i> Send Another
            </a>
        </div>
        
        <div class="mt-4">
            <a href="dashboard.php" class="text-muted">
                <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>