<?php
require_once 'config/database.php';
$page_title = "Email Receivers";
require_once 'includes/header.php';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_single'])) {
        $emails = explode(',', $_POST['emails']);
        $added = 0;
        $duplicates = 0;
        
        foreach ($emails as $email) {
            $email = trim($email);
            if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                // Check if email already exists
                $check = $conn->query("SELECT id FROM email_receivers WHERE email='$email'");
                if ($check->num_rows == 0) {
                    $conn->query("INSERT INTO email_receivers (email) VALUES ('$email')");
                    $added++;
                } else {
                    $duplicates++;
                }
            }
        }
        $message = "Added $added emails. $duplicates duplicates skipped.";
        $message_type = $added > 0 ? 'success' : 'warning';
    }
    
    if (isset($_POST['import_csv'])) {
        if (isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] == 0) {
            $file = $_FILES['csv_file']['tmp_name'];
            $handle = fopen($file, "r");
            $added = 0;
            $duplicates = 0;
            $line = 0;
            
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                $line++;
                if ($line == 1) continue; // Skip header
                
                $email = trim($data[0]);
                $name = isset($data[1]) ? trim($data[1]) : '';
                
                if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $check = $conn->query("SELECT id FROM email_receivers WHERE email='$email'");
                    if ($check->num_rows == 0) {
                        $conn->query("INSERT INTO email_receivers (email, name) VALUES ('$email', '$name')");
                        $added++;
                    } else {
                        $duplicates++;
                    }
                }
            }
            fclose($handle);
            
            $message = "CSV Import Complete: Added $added emails. $duplicates duplicates skipped.";
            $message_type = 'success';
        }
    }
    
    if (isset($_POST['delete_receiver'])) {
        $id = intval($_POST['receiver_id']);
        $conn->query("DELETE FROM email_receivers WHERE id = $id");
        $message = "Receiver deleted successfully!";
        $message_type = 'success';
    }
    
    if (isset($_POST['delete_selected'])) {
        $ids = implode(',', $_POST['selected_receivers']);
        $conn->query("DELETE FROM email_receivers WHERE id IN ($ids)");
        $message = "Selected receivers deleted successfully!";
        $message_type = 'success';
    }
}

// Get all receivers with pagination
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$totalReceivers = $conn->query("SELECT COUNT(*) as total FROM email_receivers")->fetch_assoc()['total'];
$totalPages = ceil($totalReceivers / $limit);

$receivers = $conn->query("SELECT * FROM email_receivers ORDER BY added_at DESC LIMIT $limit OFFSET $offset");
?>

<div class="container-fluid">
    <h1 class="mb-4">Email Receivers</h1>
    
    <?php if (isset($message)): ?>
        <div class="alert alert-<?php echo $message_type; ?> alert-dismissible fade show">
            <?php echo $message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <div class="row">
        <!-- Add Receivers Section -->
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-plus-circle me-2"></i>Add Receivers</h5>
                </div>
                <div class="card-body">
                    <!-- Single/Comma Separated Form -->
                    <form method="POST" class="mb-4">
                        <div class="mb-3">
                            <label class="form-label">Add Single/Comma Separated Emails</label>
                            <textarea class="form-control" name="emails" rows="4" 
                                      placeholder="Enter email addresses separated by commas
example1@email.com, example2@email.com, example3@email.com" required></textarea>
                            <div class="form-text">Enter one or more email addresses separated by commas</div>
                        </div>
                        <button type="submit" name="add_single" class="btn btn-primary">
                            <i class="fas fa-user-plus me-2"></i> Add Emails
                        </button>
                    </form>
                    
                    <hr>
                    
                    <!-- CSV Import Form -->
                    <form method="POST" enctype="multipart/form-data">
                        <div class="mb-3">
                            <label class="form-label">Import from CSV File</label>
                            <input type="file" class="form-control" name="csv_file" accept=".csv" required>
                            <div class="form-text">
                                CSV format: First column email, second column name (optional)<br>
                                <a href="sample.csv" download class="btn btn-sm btn-outline-secondary mt-2">
                                    <i class="fas fa-download me-1"></i> Download Sample CSV
                                </a>
                            </div>
                        </div>
                        <button type="submit" name="import_csv" class="btn btn-success">
                            <i class="fas fa-file-import me-2"></i> Import CSV
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- Statistics -->
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-chart-pie me-2"></i>Statistics</h5>
                </div>
                <div class="card-body">
                    <?php
                    $activeCount = $conn->query("SELECT COUNT(*) as total FROM email_receivers WHERE status='active'")->fetch_assoc()['total'];
                    $inactiveCount = $totalReceivers - $activeCount;
                    ?>
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="display-6 text-primary"><?php echo $totalReceivers; ?></div>
                            <small class="text-muted">Total Receivers</small>
                        </div>
                        <div class="col-6">
                            <div class="display-6 text-success"><?php echo $activeCount; ?></div>
                            <small class="text-muted">Active</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Receivers List -->
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Receivers List (<?php echo $totalReceivers; ?>)</h5>
                    <form method="POST" id="bulkForm" style="display:inline;">
                        <button type="submit" name="delete_selected" class="btn btn-sm btn-danger" onclick="return confirm('Delete selected receivers?')" id="deleteSelectedBtn" disabled>
                            <i class="fas fa-trash me-1"></i> Delete Selected
                        </button>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="selectAll" class="form-check-input">
                                    </th>
                                    <th>ID</th>
                                    <th>Email</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Added Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while($receiver = $receivers->fetch_assoc()): ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="selected_receivers[]" value="<?php echo $receiver['id']; ?>" class="form-check-input receiver-checkbox">
                                    </td>
                                    <td>#<?php echo $receiver['id']; ?></td>
                                    <td><?php echo htmlspecialchars($receiver['email']); ?></td>
                                    <td><?php echo htmlspecialchars($receiver['name'] ?? 'N/A'); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $receiver['status'] == 'active' ? 'success' : 'secondary'; ?>">
                                            <?php echo ucfirst($receiver['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('Y-m-d', strtotime($receiver['added_at'])); ?></td>
                                    <td>
                                        <form method="POST" style="display:inline;">
                                            <input type="hidden" name="receiver_id" value="<?php echo $receiver['id']; ?>">
                                            <button type="submit" name="delete_receiver" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this receiver?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <?php if ($totalPages > 1): ?>
                    <nav>
                        <ul class="pagination justify-content-center">
                            <li class="page-item <?php echo $page == 1 ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                            </li>
                            
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                            <?php endfor; ?>
                            
                            <li class="page-item <?php echo $page == $totalPages ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                            </li>
                        </ul>
                    </nav>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Select All functionality
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.receiver-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
    updateDeleteButton();
});

// Update delete button state
function updateDeleteButton() {
    const checkedBoxes = document.querySelectorAll('.receiver-checkbox:checked');
    const deleteBtn = document.getElementById('deleteSelectedBtn');
    const bulkForm = document.getElementById('bulkForm');
    
    if (checkedBoxes.length > 0) {
        deleteBtn.disabled = false;
        
        // Update form with selected IDs
        const selectedIds = Array.from(checkedBoxes).map(cb => cb.value);
        bulkForm.innerHTML = '<input type="hidden" name="selected_receivers[]" value="' + selectedIds.join(',') + '">' +
                           '<button type="submit" name="delete_selected" class="btn btn-sm btn-danger" onclick="return confirm(\'Delete selected receivers?\')" id="deleteSelectedBtn">' +
                           '<i class="fas fa-trash me-1"></i> Delete Selected (' + selectedIds.length + ')' +
                           '</button>';
    } else {
        deleteBtn.disabled = true;
    }
}

// Add event listeners to all checkboxes
document.querySelectorAll('.receiver-checkbox').forEach(checkbox => {
    checkbox.addEventListener('change', updateDeleteButton);
});
</script>

<?php require_once 'includes/footer.php'; ?>