<?php
require_once 'config/database.php';
$page_title = "Send Email";
require_once 'includes/header.php';

// Get templates and receivers
$templates = $conn->query("SELECT id, name FROM email_templates ORDER BY name");
$receivers = $conn->query("SELECT id, email, name FROM email_receivers WHERE status='active'");

// Handle send email
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['send_email'])) {
    $template_id = intval($_POST['template_id']);
    $subject = $conn->real_escape_string($_POST['subject']);
    $selected_receivers = isset($_POST['receivers']) ? $_POST['receivers'] : [];
    $send_to_all = isset($_POST['send_to_all']) ? 1 : 0;
    
    if ($send_to_all) {
        $receiversResult = $conn->query("SELECT id, email FROM email_receivers WHERE status='active'");
        $selected_receivers = [];
        while($row = $receiversResult->fetch_assoc()) {
            $selected_receivers[] = $row['id'];
        }
    }
    
    if (count($selected_receivers) > 0) {
        // Create campaign
        $conn->query("INSERT INTO email_campaigns (template_id, subject, receivers_count, status) 
                     VALUES ($template_id, '$subject', " . count($selected_receivers) . ", 'pending')");
        $campaign_id = $conn->insert_id;
        
        // Store receivers for this campaign
        foreach ($selected_receivers as $receiver_id) {
            $conn->query("INSERT INTO campaign_receivers (campaign_id, receiver_id) VALUES ($campaign_id, $receiver_id)");
        }
        
        $_SESSION['campaign_id'] = $campaign_id;
        echo '<script>window.location.href = "process-mail.php";</script>';
        exit();
    } else {
        $error = "Please select at least one receiver!";
    }
}
?>

<div class="container-fluid">
    <h1 class="mb-4">Send Email Campaign</h1>
    
    <?php if (isset($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?php echo $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <form method="POST" id="sendEmailForm">
        <div class="row">
            <!-- Left Column -->
            <div class="col-lg-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0"><i class="fas fa-cog me-2"></i>Campaign Settings</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Email Subject *</label>
                            <input type="text" class="form-control" name="subject" required 
                                   placeholder="Enter email subject line">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Select Template *</label>
                            <select class="form-select" name="template_id" required id="templateSelect">
                                <option value="">-- Select Template --</option>
                                <?php while($template = $templates->fetch_assoc()): ?>
                                <option value="<?php echo $template['id']; ?>">
                                    <?php echo htmlspecialchars($template['name']); ?>
                                </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="send_to_all" id="sendToAll">
                                <label class="form-check-label" for="sendToAll">
                                    Send to all active receivers
                                </label>
                            </div>
                        </div>
                        
                        <div id="templatePreview" class="mb-3" style="display:none;">
                            <label class="form-label">Template Preview</label>
                            <div class="border rounded p-3 bg-light" style="max-height: 300px; overflow-y: auto;">
                                <div id="previewContent"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Right Column -->
            <div class="col-lg-6">
                <div class="card shadow-sm">
                    <div class="card-header bg-white">
                        <h5 class="mb-0"><i class="fas fa-users me-2"></i>Select Receivers</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Select receivers manually:</span>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="selectAllReceivers">
                                    <label class="form-check-label" for="selectAllReceivers">
                                        Select All
                                    </label>
                                </div>
                            </div>
                            <div class="receivers-list border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                                <?php 
                                $receivers->data_seek(0); // Reset pointer to beginning
                                while($receiver = $receivers->fetch_assoc()): ?>
                                <div class="form-check mb-2">
                                    <input class="form-check-input receiver-check" type="checkbox" 
                                           name="receivers[]" value="<?php echo $receiver['id']; ?>"
                                           id="receiver_<?php echo $receiver['id']; ?>">
                                    <label class="form-check-label" for="receiver_<?php echo $receiver['id']; ?>">
                                        <?php echo htmlspecialchars($receiver['email']); ?>
                                        <?php if ($receiver['name']): ?>
                                        <span class="text-muted">(<?php echo htmlspecialchars($receiver['name']); ?>)</span>
                                        <?php endif; ?>
                                    </label>
                                </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Total Active Receivers:</strong> 
                            <?php echo $receivers->num_rows; ?> emails
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Submit Section -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card shadow-sm">
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                Before sending, make sure your SMTP settings are configured correctly in Settings page.
                            </div>
                        </div>
                        
                        <button type="submit" name="send_email" class="btn btn-primary btn-lg px-5" id="sendButton">
                            <i class="fas fa-paper-plane me-2"></i> Send Email Campaign
                        </button>
                        
                        <div class="mt-3">
                            <small class="text-muted">
                                <i class="fas fa-clock me-1"></i>
                                This will send emails in the background. You can track progress in Reports.
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Template Preview Modal -->
<div class="modal fade" id="templatePreviewModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Template Preview</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <iframe id="previewFrame" style="width:100%; height:500px; border:none;"></iframe>
            </div>
        </div>
    </div>
</div>

<script>
// Template preview - SIMPLIFIED VERSION
document.getElementById('templateSelect').addEventListener('change', function() {
    const templateId = this.value;
    const previewDiv = document.getElementById('templatePreview');
    const previewContent = document.getElementById('previewContent');
    
    if (templateId) {
        // Show loading
        previewContent.innerHTML = '<div class="text-center py-4"><div class="spinner-border text-primary"></div><p class="mt-2">Loading template...</p></div>';
        previewDiv.style.display = 'block';
        
        // Use fetch API to get template content
        fetch('ajax/get_template.php?id=' + templateId)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    // Show limited preview (first 500 characters)
                    const htmlContent = data.html_content;
                    const textContent = htmlContent.replace(/<[^>]*>/g, ''); // Remove HTML tags
                    const previewText = textContent.substring(0, 500) + (textContent.length > 500 ? '...' : '');
                    
                    previewContent.innerHTML = `
                        <h6>${data.name}</h6>
                        <p>${previewText}</p>
                        <button type="button" class="btn btn-sm btn-outline-primary" onclick="showFullPreview(${templateId})">
                            <i class="fas fa-expand me-1"></i> View Full Template
                        </button>
                    `;
                } else {
                    previewContent.innerHTML = '<div class="alert alert-danger">Template not found</div>';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                previewContent.innerHTML = '<div class="alert alert-danger">Error loading template</div>';
            });
    } else {
        previewDiv.style.display = 'none';
    }
});

// Show full template preview in modal
function showFullPreview(templateId) {
    fetch('ajax/get_template.php?id=' + templateId)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const iframe = document.getElementById('previewFrame');
                const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
                
                iframeDoc.open();
                iframeDoc.write(data.html_content);
                iframeDoc.close();
                
                const modal = new bootstrap.Modal(document.getElementById('templatePreviewModal'));
                modal.show();
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error loading template preview');
        });
}

// Select all receivers
document.getElementById('selectAllReceivers').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.receiver-check');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// Send to all toggle
document.getElementById('sendToAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.receiver-check');
    const selectAllCheckbox = document.getElementById('selectAllReceivers');
    
    if (this.checked) {
        checkboxes.forEach(checkbox => {
            checkbox.disabled = true;
            checkbox.checked = false;
        });
        selectAllCheckbox.disabled = true;
        selectAllCheckbox.checked = false;
    } else {
        checkboxes.forEach(checkbox => {
            checkbox.disabled = false;
        });
        selectAllCheckbox.disabled = false;
    }
});

// Form validation
document.getElementById('sendEmailForm').addEventListener('submit', function(e) {
    const sendToAll = document.getElementById('sendToAll').checked;
    const hasSelectedReceivers = document.querySelectorAll('.receiver-check:checked').length > 0;
    const templateSelected = document.getElementById('templateSelect').value !== '';
    const subjectFilled = document.querySelector('input[name="subject"]').value.trim() !== '';
    
    if (!templateSelected) {
        e.preventDefault();
        alert('Please select a template!');
        return false;
    }
    
    if (!subjectFilled) {
        e.preventDefault();
        alert('Please enter email subject!');
        return false;
    }
    
    if (!sendToAll && !hasSelectedReceivers) {
        e.preventDefault();
        alert('Please select at least one receiver or choose "Send to all active receivers"');
        return false;
    }
    
    // Show confirmation
    const confirmSend = confirm('Are you sure you want to send this email campaign?');
    if (!confirmSend) {
        e.preventDefault();
        return false;
    }
    
    const sendButton = document.getElementById('sendButton');
    sendButton.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Preparing to Send...';
    sendButton.disabled = true;
});
</script>

<?php require_once 'includes/footer.php'; ?>