<?php
require_once 'config/database.php';
$page_title = "SMTP Settings";
require_once 'includes/header.php';

// Get SMTP settings
$smtp = $conn->query("SELECT * FROM smtp_settings LIMIT 1")->fetch_assoc();
if (!$smtp) {
    $conn->query("INSERT INTO smtp_settings (host, port, username, password, encryption, from_email, from_name) 
                 VALUES ('smtp.gmail.com', 587, 'your-email@gmail.com', 'your-password', 'tls', 'your-email@gmail.com', 'Mail System')");
    $smtp = $conn->query("SELECT * FROM smtp_settings LIMIT 1")->fetch_assoc();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['save_smtp'])) {
        $host = $conn->real_escape_string($_POST['host']);
        $port = intval($_POST['port']);
        $username = $conn->real_escape_string($_POST['username']);
        $password = $conn->real_escape_string($_POST['password']);
        $encryption = $conn->real_escape_string($_POST['encryption']);
        $from_email = $conn->real_escape_string($_POST['from_email']);
        $from_name = $conn->real_escape_string($_POST['from_name']);
        
        $conn->query("UPDATE smtp_settings SET 
                     host = '$host',
                     port = $port,
                     username = '$username',
                     password = '$password',
                     encryption = '$encryption',
                     from_email = '$from_email',
                     from_name = '$from_name',
                     updated_at = NOW()");
        $success = "SMTP settings saved successfully!";
        $smtp = $conn->query("SELECT * FROM smtp_settings LIMIT 1")->fetch_assoc();
    }
    
    if (isset($_POST['test_smtp'])) {
        // Try to load PHPMailer
        $phpmailer_loaded = false;
        $test_result = '';
        
        // Path to PHPMailer
        $phpmailer_path = dirname(__DIR__) . '/vendor/phpmailer/phpmailer/src/';
        
        if (file_exists($phpmailer_path . 'PHPMailer.php')) {
            require_once $phpmailer_path . 'PHPMailer.php';
            require_once $phpmailer_path . 'SMTP.php';
            require_once $phpmailer_path . 'Exception.php';
            
            try {
                $mail = new PHPMailer\PHPMailer\PHPMailer(true);
                
                // Server settings
                $mail->isSMTP();
                $mail->Host = $_POST['host'];
                $mail->Port = $_POST['port'];
                $mail->SMTPAuth = true;
                $mail->Username = $_POST['username'];
                $mail->Password = $_POST['password'];
                $mail->SMTPSecure = $_POST['encryption'];
                $mail->SMTPDebug = 0;
                
                // Recipients
                $mail->setFrom($_POST['from_email'], $_POST['from_name']);
                $mail->addAddress($_SESSION['email'], $_SESSION['username']);
                
                // Content
                $mail->isHTML(true);
                $mail->Subject = 'SMTP Test Email - Mail System';
                $mail->Body = '<h2>SMTP Test Successful!</h2><p>Your SMTP settings are working correctly.</p>';
                $mail->AltBody = 'SMTP Test Successful! Your SMTP settings are working correctly.';
                
                $mail->send();
                $test_result = '<div class="alert alert-success">✅ Test email sent successfully! Check your inbox.</div>';
                $phpmailer_loaded = true;
            } catch (Exception $e) {
                $test_result = '<div class="alert alert-danger">❌ SMTP Error: ' . $mail->ErrorInfo . '</div>';
                $phpmailer_loaded = true;
            }
        }
        
        // If PHPMailer not available, use PHP mail()
        if (!$phpmailer_loaded) {
            $to = $_SESSION['email'];
            $subject = 'SMTP Test Email - Mail System';
            $message = 'SMTP Test Successful! Your SMTP settings are working correctly.';
            $headers = "From: " . $_POST['from_name'] . " <" . $_POST['from_email'] . ">\r\n";
            $headers .= "Reply-To: " . $_POST['from_email'] . "\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
            
            if (mail($to, $subject, $message, $headers)) {
                $test_result = '<div class="alert alert-success">✅ Test email sent using PHP mail() function! Check your inbox.</div>';
            } else {
                $test_result = '<div class="alert alert-danger">❌ Failed to send test email using PHP mail() function.</div>';
            }
        }
    }
}
?>

<div class="container-fluid">
    <h1 class="mb-4">SMTP Settings</h1>
    
    <?php if (isset($success)): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?php echo $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <?php if (isset($test_result)) echo $test_result; ?>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-server me-2"></i>SMTP Configuration</h5>
                </div>
                <div class="card-body">
                    <form method="POST" id="smtpForm">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">SMTP Host *</label>
                                <input type="text" class="form-control" name="host" 
                                       value="<?php echo htmlspecialchars($smtp['host']); ?>" required>
                                <div class="form-text">e.g., smtp.gmail.com, smtp.sendgrid.net</div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Port *</label>
                                <input type="number" class="form-control" name="port" 
                                       value="<?php echo $smtp['port']; ?>" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Username *</label>
                                <input type="text" class="form-control" name="username" 
                                       value="<?php echo htmlspecialchars($smtp['username']); ?>" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Password *</label>
                                <input type="password" class="form-control" name="password" 
                                       value="<?php echo htmlspecialchars($smtp['password']); ?>" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Encryption *</label>
                                <select class="form-select" name="encryption" required>
                                    <option value="tls" <?php echo $smtp['encryption'] == 'tls' ? 'selected' : ''; ?>>TLS</option>
                                    <option value="ssl" <?php echo $smtp['encryption'] == 'ssl' ? 'selected' : ''; ?>>SSL</option>
                                    <option value="" <?php echo empty($smtp['encryption']) ? 'selected' : ''; ?>>None</option>
                                </select>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">From Email *</label>
                                <input type="email" class="form-control" name="from_email" 
                                       value="<?php echo htmlspecialchars($smtp['from_email']); ?>" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">From Name *</label>
                            <input type="text" class="form-control" name="from_name" 
                                   value="<?php echo htmlspecialchars($smtp['from_name']); ?>" required>
                        </div>
                        
                        <div class="d-flex justify-content-between">
                            <button type="submit" name="test_smtp" class="btn btn-info">
                                <i class="fas fa-vial me-2"></i> Test SMTP Connection
                            </button>
                            <button type="submit" name="save_smtp" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i> Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>SMTP Guides</h5>
                </div>
                <div class="card-body">
                    <h6>Popular SMTP Services:</h6>
                    
                    <div class="list-group mb-3">
                        <div class="list-group-item">
                            <h6 class="mb-1">Gmail</h6>
                            <small class="text-muted">Host: smtp.gmail.com<br>Port: 587 (TLS) or 465 (SSL)</small>
                        </div>
                        <div class="list-group-item">
                            <h6 class="mb-1">SendGrid</h6>
                            <small class="text-muted">Host: smtp.sendgrid.net<br>Port: 587 (TLS)</small>
                        </div>
                        <div class="list-group-item">
                            <h6 class="mb-1">Amazon SES</h6>
                            <small class="text-muted">Host: email-smtp.us-east-1.amazonaws.com<br>Port: 587 (TLS)</small>
                        </div>
                    </div>
                    
                    <div class="alert alert-warning">
                        <h6><i class="fas fa-exclamation-triangle me-2"></i>Important Notes:</h6>
                        <small>
                            <ul class="mb-0 ps-3">
                                <li>For Gmail, enable "Less secure app access" or use App Password</li>
                                <li>Test connection before sending actual emails</li>
                                <li>Keep credentials secure</li>
                            </ul>
                        </small>
                    </div>
                </div>
            </div>
            
            <!-- Current Settings -->
            <div class="card shadow-sm mt-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-check-circle me-2"></i>Current Settings</h5>
                </div>
                <div class="card-body">
                    <dl class="mb-0">
                        <dt>Status</dt>
                        <dd>
                            <span class="badge bg-<?php echo $smtp['is_active'] ? 'success' : 'danger'; ?>">
                                <?php echo $smtp['is_active'] ? 'Active' : 'Inactive'; ?>
                            </span>
                        </dd>
                        <dt>Last Updated</dt>
                        <dd><?php echo $smtp['updated_at'] ? date('Y-m-d H:i', strtotime($smtp['updated_at'])) : 'Never'; ?></dd>
                    </dl>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>