<?php
require_once 'config/database.php';
$page_title = "Email Templates";
require_once 'includes/header.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['save_template'])) {
        $name = $conn->real_escape_string($_POST['name']);
        $html_content = $conn->real_escape_string($_POST['html_content']);
        
        $conn->query("INSERT INTO email_templates (name, html_content) VALUES ('$name', '$html_content')");
        $success = "Template saved successfully!";
    } elseif (isset($_POST['delete_template'])) {
        $id = intval($_POST['template_id']);
        $conn->query("DELETE FROM email_templates WHERE id = $id");
        $success = "Template deleted successfully!";
    }
}

// Get all templates
$templates = $conn->query("SELECT * FROM email_templates ORDER BY created_at DESC");
?>

<div class="container-fluid">
    <h1 class="mb-4">Email Templates</h1>
    
    <?php if (isset($success)): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?php echo $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <div class="row">
        <!-- Template List -->
        <div class="col-lg-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Saved Templates</h5>
                    <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#newTemplateModal">
                        <i class="fas fa-plus"></i> New Template
                    </button>
                </div>
                <div class="card-body">
                    <div class="list-group">
                        <?php while($template = $templates->fetch_assoc()): ?>
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-1"><?php echo htmlspecialchars($template['name']); ?></h6>
                                    <small class="text-muted">Created: <?php echo date('Y-m-d', strtotime($template['created_at'])); ?></small>
                                </div>
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-outline-primary" onclick="loadTemplate(<?php echo $template['id']; ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="template_id" value="<?php echo $template['id']; ?>">
                                        <button type="submit" name="delete_template" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this template?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Template Editor -->
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Template Editor</h5>
                </div>
                <div class="card-body">
                    <form method="POST" id="templateForm">
                        <div class="mb-3">
                            <label class="form-label">Template Name</label>
                            <input type="text" class="form-control" name="name" id="templateName" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">HTML Content</label>
                            <textarea class="form-control" name="html_content" id="htmlContent" rows="15" required></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-info" onclick="insertTemplate('forex')">
                                    <i class="fas fa-coins"></i> Forex Template
                                </button>
                                <button type="button" class="btn btn-outline-secondary" onclick="insertTemplate('basic')">
                                    <i class="fas fa-file-alt"></i> Basic Template
                                </button>
                                <button type="button" class="btn btn-outline-success" onclick="insertTemplate('award')">
                                    <i class="fas fa-trophy"></i> Award Template
                                </button>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-info" onclick="previewTemplate()">
                                <i class="fas fa-eye"></i> Preview
                            </button>
                            <button type="submit" name="save_template" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Template
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Preview Modal -->
            <div class="modal fade" id="previewModal" tabindex="-1">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Template Preview</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <iframe id="previewFrame" style="width:100%; height:500px; border:none;"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- New Template Modal -->
<div class="modal fade" id="newTemplateModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Create New Template</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Template Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Choose Template Type</label>
                        <select class="form-select" id="templateType">
                            <option value="forex">Forex Broker Award Template</option>
                            <option value="basic">Basic Email Template</option>
                            <option value="award">Award Announcement</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="createNewTemplate()">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function insertTemplate(type) {
    let content = '';
    
    if (type === 'forex') {
        content = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forex Broker Award</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 10px 10px; }
        .award-badge { text-align: center; margin: 20px 0; }
        .award-badge img { max-width: 150px; }
        .cta-button { display: inline-block; background: #28a745; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .footer { text-align: center; margin-top: 30px; color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class="header">
        <h1>🎖️ Forex Broker Excellence Award 2024</h1>
        <p>Recognizing Outstanding Performance in Forex Trading</p>
    </div>
    <div class="content">
        <h2>Dear [Client Name],</h2>
        
        <div class="award-badge">
            <!-- You can add an award image here -->
            <div style="font-size: 60px;">🏆</div>
        </div>
        
        <p>We are thrilled to announce that <strong>Your Broker Name</strong> has been awarded the prestigious <strong>"Best Forex Broker 2024"</strong> award by the International Financial Market Association.</p>
        
        <h3>Award Highlights:</h3>
        <ul>
            <li>Best Trading Platform 2024</li>
            <li>Most Innovative Technology</li>
            <li>Highest Client Satisfaction</li>
            <li>Best Customer Support</li>
        </ul>
        
        <p>This recognition reflects our commitment to providing you with the best trading experience, cutting-edge technology, and exceptional customer service.</p>
        
        <div style="text-align: center;">
            <a href="https://your-broker.com" class="cta-button">🎯 Start Trading Now</a>
        </div>
        
        <p>Join thousands of satisfied traders who have chosen excellence. Experience award-winning trading conditions today!</p>
        
        <div class="footer">
            <p>Best Regards,<br>
            <strong>The Award-Winning Team</strong><br>
            Your Broker Name<br>
            Email: support@yourbroker.com<br>
            Phone: +1 (555) 123-4567</p>
            
            <p style="border-top: 1px solid #ddd; padding-top: 10px; margin-top: 20px;">
                This email was sent to [Email Address].<br>
                © 2024 Your Broker Name. All rights reserved.
            </p>
        </div>
    </div>
</body>
</html>`;
    } else if (type === 'award') {
        content = `<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: auto; }
        .award-header { background: #1a365d; color: white; padding: 30px; text-align: center; }
        .content { padding: 30px; background: #f7fafc; }
        .badge { font-size: 80px; text-align: center; margin: 20px; }
    </style>
</head>
<body>
    <div class="award-header">
        <h1>🏅 Excellence Award Notification</h1>
    </div>
    <div class="content">
        <p>Congratulations! Your achievement has been recognized.</p>
        <div class="badge">🏆</div>
    </div>
</body>
</html>`;
    } else {
        content = `<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: auto; padding: 20px; }
        .header { background: #4F46E5; color: white; padding: 20px; text-align: center; }
        .content { padding: 30px; background: #f9fafb; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Email Template</h1>
    </div>
    <div class="content">
        <h2>Hello [Name],</h2>
        <p>This is a basic email template. Customize it as needed.</p>
        <p>Best regards,<br>Your Company</p>
    </div>
</body>
</html>`;
    }
    
    document.getElementById('htmlContent').value = content;
}

function previewTemplate() {
    const content = document.getElementById('htmlContent').value;
    const iframe = document.getElementById('previewFrame');
    const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
    
    iframeDoc.open();
    iframeDoc.write(content);
    iframeDoc.close();
    
    const modal = new bootstrap.Modal(document.getElementById('previewModal'));
    modal.show();
}

function createNewTemplate() {
    const name = document.querySelector('#newTemplateModal input[name="name"]').value;
    const type = document.getElementById('templateType').value;
    
    document.getElementById('templateName').value = name;
    insertTemplate(type);
    
    const modal = bootstrap.Modal.getInstance(document.getElementById('newTemplateModal'));
    modal.hide();
}

function loadTemplate(id) {
    fetch('ajax/get_template.php?id=' + id)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('templateName').value = data.name;
                document.getElementById('htmlContent').value = data.html_content;
            }
        });
}
</script>

<?php require_once 'includes/footer.php'; ?>